/*
 * Decompiled with CFR 0.152.
 */
package TileMap;

import TileMap.Tile;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class TileMap {
    private double x;
    private double y;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private double tween;
    private int[][] map;
    private int tileSize;
    private int numRows;
    private int numCols;
    private int width;
    private int height;
    private BufferedImage tileset;
    private int numTilesAcross;
    private Tile[][] tiles;
    private int rowOffset;
    private int colOffset;
    private int numRowsToDraw;
    private int numColsToDraw;

    public TileMap(int tileSize) {
        this.tileSize = tileSize;
        this.numRowsToDraw = 240 / tileSize + 2;
        this.numColsToDraw = 320 / tileSize + 2;
        this.tween = 0.07;
    }

    public void loadTiles(String s) {
        try {
            this.tileset = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.numTilesAcross = this.tileset.getWidth() / this.tileSize;
            this.tiles = new Tile[2][this.numTilesAcross];
            int col = 0;
            while (col < this.numTilesAcross) {
                BufferedImage subimage = this.tileset.getSubimage(col * this.tileSize, 0, this.tileSize, this.tileSize);
                this.tiles[0][col] = new Tile(subimage, 0);
                subimage = this.tileset.getSubimage(col * this.tileSize, this.tileSize, this.tileSize, this.tileSize);
                this.tiles[1][col] = new Tile(subimage, 1);
                ++col;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadMap(String s) {
        try {
            InputStream in = this.getClass().getResourceAsStream(s);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.numCols = Integer.parseInt(br.readLine());
            this.numRows = Integer.parseInt(br.readLine());
            this.map = new int[this.numRows][this.numCols];
            this.width = this.numCols * this.tileSize;
            this.height = this.numRows * this.tileSize;
            this.xmin = 320 - this.width;
            this.xmax = 0;
            this.ymin = 240 - this.height;
            this.ymax = 0;
            String delims = "\\s+";
            int row = 0;
            while (row < this.numRows) {
                String line = br.readLine();
                String[] tokens = line.split(delims);
                int col = 0;
                while (col < this.numCols) {
                    this.map[row][col] = Integer.parseInt(tokens[col]);
                    ++col;
                }
                ++row;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public double getx() {
        return this.x;
    }

    public double gety() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType(int row, int col) {
        int rc = this.map[row][col];
        int r = rc / this.numTilesAcross;
        int c = rc % this.numTilesAcross;
        return this.tiles[r][c].getType();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void setPosition(double x, double y) {
        this.x += (x - this.x) * this.tween;
        this.y += (y - this.y) * this.tween;
        this.fixBounds();
        this.colOffset = (int)(-this.x) / this.tileSize;
        this.rowOffset = (int)(-this.y) / this.tileSize;
    }

    private void fixBounds() {
        if (this.x < (double)this.xmin) {
            this.x = this.xmin;
        }
        if (this.y < (double)this.ymin) {
            this.y = this.ymin;
        }
        if (this.x > (double)this.xmax) {
            this.x = this.xmax;
        }
        if (this.y > (double)this.ymax) {
            this.y = this.ymax;
        }
    }

    public void draw(Graphics2D g) {
        int row = this.rowOffset;
        while (row < this.rowOffset + this.numRowsToDraw) {
            if (row >= this.numRows) break;
            int col = this.colOffset;
            while (col < this.colOffset + this.numColsToDraw) {
                if (col >= this.numCols) break;
                if (this.map[row][col] != 0) {
                    int rc = this.map[row][col];
                    int r = rc / this.numTilesAcross;
                    int c = rc % this.numTilesAcross;
                    g.drawImage((Image)this.tiles[r][c].getImage(), (int)this.x + col * this.tileSize, (int)this.y + row * this.tileSize, null);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setTween(double d) {
        this.tween = d;
    }
}

